-- Demo Data for Student ID 1
-- Discipline Records
INSERT INTO `discipline_records` (`id`, `student_id`, `incident_date`, `incident_type`, `severity`, `description`, `action_taken`, `reported_by`, `parent_notified`, `notification_date`, `status`, `created_at`) VALUES
(1, 1, '2026-01-15', 'Late to class', 'minor', 'Student arrived 10 minutes late to Mathematics class', 'Verbal warning given', 6, 1, '2026-01-15', 'resolved', NOW()),
(2, 1, '2026-01-10', 'Incomplete assignment', 'minor', 'Did not submit Mathematics homework on time', 'Asked to submit by next day', 6, 0, NULL, 'resolved', NOW()),
(3, 1, '2026-01-05', 'Uniform violation', 'minor', 'Did not wear complete uniform', 'Parent notified and corrected next day', 7, 1, '2026-01-05', 'resolved', NOW());

-- Library Books (if not already exist)
INSERT INTO `library_books` (`id`, `book_title`, `book_author`, `isbn`, `book_code`, `category`, `publication_year`, `publisher`, `total_copies`, `available_copies`, `book_description`, `created_at`) VALUES
(100, 'Mathematics for Beginners', 'Jane Smith', '978-1-234567-89-0', 'MATH001', 'Science', 2020, 'Educational Press', 5, 3, 'Comprehensive guide to basic mathematics', NOW()),
(101, 'English Grammar Guide', 'John Doe', '978-1-234567-90-6', 'ENG001', 'Language', 2019, 'Language Academy', 4, 2, 'Complete English grammar reference', NOW()),
(102, 'World History', 'David Wilson', '978-1-234567-91-3', 'HIST001', 'History', 2021, 'History Press', 3, 1, 'World history from ancient to modern times', NOW());

-- Library Borrowings for Student 1
INSERT INTO `library_borrowing` (`id`, `student_id`, `book_id`, `borrow_date`, `due_date`, `return_date`, `status`, `fine_amount`, `fine_paid`, `librarian_id`, `created_at`) VALUES
(100, 1, 100, '2026-01-10', '2026-01-24', NULL, 'borrowed', 0.00, 0, 8, NOW()),
(101, 1, 101, '2026-01-08', '2026-01-22', '2026-01-20', 'returned', 0.00, 1, 8, NOW()),
(102, 1, 102, '2026-01-18', '2026-02-01', NULL, 'borrowed', 0.00, 0, 8, NOW());

-- Extracurricular Activities (if not already exist)
INSERT INTO `extracurricular_activities` (`id`, `activity_name`, `activity_type`, `description`, `meeting_day`, `meeting_time`, `location`, `coordinator_id`, `session_year`, `is_active`, `created_at`, `updated_at`) VALUES
(100, 'Debate Club', 'academic', 'Practice public speaking and debate skills', 'Tuesday', '15:30:00', 'Room 105', 6, '2025/2026', 1, NOW(), NOW()),
(101, 'Football Team', 'sports', 'School football team practices and matches', 'Wednesday', '16:00:00', 'School Field', 7, '2025/2026', 1, NOW(), NOW()),
(102, 'Science Club', 'academic', 'Explore science through experiments and projects', 'Thursday', '15:30:00', 'Science Lab', 6, '2025/2026', 1, NOW(), NOW());

-- Activity Participation for Student 1
INSERT INTO `activity_participation` (`id`, `student_id`, `activity_id`, `join_date`, `status`, `participation_level`, `achievements`, `created_at`) VALUES
(100, 1, 100, '2026-01-05', 'active', 'regular', 'Won 2nd place in inter-class debate', NOW()),
(101, 1, 101, '2026-01-06', 'active', 'regular', 'Scored in friendly match', NOW()),
(102, 1, 102, '2026-01-07', 'active', 'high', 'Active participant in all experiments', NOW());

-- Report Card Data (Results) for Student 1
-- Term 1 Results for 2025/2026 Academic Year
INSERT INTO `results` (`id`, `student_id`, `session_year`, `term`, `subject`, `ca1`, `ca2`, `exam`, `grade`, `position_in_class`, `teacher_remark`, `principal_remark`, `created_at`) VALUES
(1001, 1, '2025/2026', '1st', 'Mathematics', 8.00, 9.00, 35.00, 'A', 5, 'Good performance. Student shows strong problem-solving skills.', 'Keep it up', NOW()),
(1002, 1, '2025/2026', '1st', 'English Language', 8.00, 9.00, 38.00, 'A', 3, 'Excellent writing and comprehension skills demonstrated.', 'Very good', NOW()),
(1003, 1, '2025/2026', '1st', 'Science', 7.00, 8.00, 34.00, 'B+', 8, 'Adequate understanding of concepts. Needs more practical work.', 'Satisfactory', NOW()),
(1004, 1, '2025/2026', '1st', 'History', 8.00, 9.00, 40.00, 'A', 2, 'Outstanding knowledge of historical events and analysis.', 'Excellent', NOW()),
(1005, 1, '2025/2026', '1st', 'Geography', 8.00, 8.00, 36.00, 'A', 4, 'Good grasp of geographical concepts and map reading skills.', 'Well done', NOW()),
(1006, 1, '2025/2026', '1st', 'Computer Science', 8.00, 9.00, 38.00, 'A', 3, 'Strong programming skills and logical thinking demonstrated.', 'Very good', NOW());

-- Term 2 Results for 2025/2026 Academic Year
INSERT INTO `results` (`id`, `student_id`, `session_year`, `term`, `subject`, `ca1`, `ca2`, `exam`, `grade`, `position_in_class`, `teacher_remark`, `principal_remark`, `created_at`) VALUES
(1007, 1, '2025/2026', '2nd', 'Mathematics', 8.00, 9.00, 36.00, 'A', 4, 'Improvement noted. Student engaged well in lessons.', 'Keep it up', NOW()),
(1008, 1, '2025/2026', '2nd', 'English Language', 8.00, 9.00, 39.00, 'A', 2, 'Consistent excellence in all aspects of the language.', 'Excellent work', NOW()),
(1009, 1, '2025/2026', '2nd', 'Science', 8.00, 8.00, 35.00, 'B+', 6, 'Good experimental work. Continue to build practical skills.', 'Satisfactory', NOW()),
(1010, 1, '2025/2026', '2nd', 'History', 9.00, 9.00, 41.00, 'A', 1, 'Outstanding performance. Class topper in this subject.', 'Excellent', NOW()),
(1011, 1, '2025/2026', '2nd', 'Geography', 8.00, 8.00, 37.00, 'A', 3, 'Consistent performance with good project submissions.', 'Very good', NOW()),
(1012, 1, '2025/2026', '2nd', 'Computer Science', 9.00, 9.00, 40.00, 'A', 2, 'Advanced programming concepts well understood and applied.', 'Excellent', NOW());
