<?php
/**
 * Database Connection Class
 * Configure your localhost MySQL connection here
 */

class Database {
    private $host = 'localhost';
    private $db_name = 'school_portal';  // Update if your database name is different
    private $user = 'root';                      // XAMPP default user
    private $password = '';                      // XAMPP default (empty for root)
    private $pdo;

    public function connect() {
        $this->pdo = null;

        try {
            $this->pdo = new PDO(
                'mysql:host=' . $this->host . ';dbname=' . $this->db_name . ';charset=utf8mb4',
                $this->user,
                $this->password
            );
            $this->pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        } catch(PDOException $e) {
            echo json_encode([
                'success' => false,
                'message' => 'Database Connection Error: ' . $e->getMessage()
            ]);
            exit;
        }

        return $this->pdo;
    }
}
?>
