<?php
// api_discipline.php - Discipline Records API Endpoint

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST');
header('Access-Control-Allow-Headers: Content-Type');

$request_method = $_SERVER['REQUEST_METHOD'];
$action = isset($_GET['action']) ? $_GET['action'] : '';

// Database connection
$db_host = 'localhost';
$db_user = 'root';
$db_pass = '';
$db_name = 'school_portal';

try {
    $pdo = new PDO("mysql:host=$db_host;dbname=$db_name", $db_user, $db_pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Database connection failed']);
    exit();
}

if ($request_method === 'GET') {
    if ($action === 'getDisciplineRecords') {
        $studentId = isset($_GET['student_id']) ? intval($_GET['student_id']) : 1;
        
        try {
            $query = "SELECT 
                dr.id, dr.incident_date, dr.incident_type, dr.severity, dr.description, 
                dr.action_taken, dr.parent_notified, dr.notification_date, dr.status,
                u.full_name as reported_by
            FROM discipline_records dr
            JOIN users u ON dr.reported_by = u.id
            WHERE dr.student_id = :student_id
            ORDER BY dr.incident_date DESC";
            
            $stmt = $pdo->prepare($query);
            $stmt->execute(['student_id' => $studentId]);
            $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
            
            http_response_code(200);
            echo json_encode(['success' => true, 'discipline_records' => $result]);
        } catch (Exception $e) {
            http_response_code(500);
            echo json_encode(['error' => $e->getMessage()]);
        }
    }
}
?>
