<?php
/**
 * Attendance API Endpoint
 * Retrieves attendance data for a student
 */

header('Content-Type: application/json');
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");

if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    http_response_code(200);
    exit();
}

require_once '../config/Database.php';

if ($_SERVER['REQUEST_METHOD'] == 'GET') {
    $db = new Database();
    $pdo = $db->connect();

    if (isset($_GET['student_id']) && !empty($_GET['student_id'])) {
        $student_id = filter_var($_GET['student_id'], FILTER_SANITIZE_NUMBER_INT);
        
        try {
            // Get attendance summary
            $query = "SELECT 
                        status,
                        COUNT(*) as count
                      FROM attendance
                      WHERE student_id = :student_id
                      GROUP BY status";
            
            $stmt = $pdo->prepare($query);
            $stmt->bindParam(':student_id', $student_id);
            $stmt->execute();
            
            $attendance_records = $stmt->fetchAll(PDO::FETCH_ASSOC);
            
            // Format the data
            $summary = [
                'present' => 0,
                'absent' => 0,
                'late' => 0,
                'excused' => 0
            ];
            
            foreach ($attendance_records as $record) {
                if (isset($summary[$record['status']])) {
                    $summary[$record['status']] = (int)$record['count'];
                }
            }
            
            echo json_encode([
                'success' => true,
                'data' => $summary
            ]);
        } catch (Exception $e) {
            http_response_code(500);
            echo json_encode([
                'success' => false,
                'message' => 'Error: ' . $e->getMessage()
            ]);
        }
    } else {
        http_response_code(400);
        echo json_encode([
            'success' => false,
            'message' => 'Student ID is required'
        ]);
    }
} else {
    http_response_code(405);
    echo json_encode([
        'success' => false,
        'message' => 'Method not allowed'
    ]);
}
?>
