<?php
header('Content-Type: application/json');
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");

require_once '../config/Database.php';

$action = $_GET['action'] ?? 'getStudentBorrowings';
$student_id = $_GET['student_id'] ?? 1;
$category = $_GET['category'] ?? null;

$db = new Database();
$pdo = $db->connect();

try {
    if ($action === 'getStudentBorrowings') {
        // Get books borrowed by a student
        $query = "
            SELECT 
                lb.id as borrowing_id,
                b.id as book_id,
                b.book_title,
                b.book_author,
                b.isbn,
                b.category as book_category,
                lb.borrow_date,
                lb.due_date,
                lb.return_date,
                lb.status,
                lb.fine_amount
            FROM library_borrowing lb
            JOIN library_books b ON lb.book_id = b.id
            WHERE lb.student_id = :student_id
            ORDER BY lb.borrow_date DESC
        ";
        
        $stmt = $pdo->prepare($query);
        $stmt->bindParam(':student_id', $student_id, PDO::PARAM_INT);
        $stmt->execute();
        $borrowings = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        echo json_encode([
            'success' => true,
            'message' => 'Borrowings retrieved successfully',
            'data' => $borrowings
        ]);
        
    } elseif ($action === 'getBooks') {
        // Get available books
        $query = "
            SELECT 
                b.id as book_id,
                b.book_title,
                b.book_author,
                b.isbn,
                b.category as book_category,
                b.total_copies,
                b.available_copies,
                b.created_at as acquisition_date
            FROM library_books b
            WHERE b.available_copies > 0
        ";
        
        if ($category) {
            $query .= " AND b.category = :category";
        }
        
        $query .= " ORDER BY b.book_title";
        
        $stmt = $pdo->prepare($query);
        if ($category) {
            $stmt->bindParam(':category', $category, PDO::PARAM_STR);
        }
        $stmt->execute();
        $books = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        echo json_encode([
            'success' => true,
            'message' => 'Books retrieved successfully',
            'data' => $books
        ]);
    }
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Database error: ' . $e->getMessage()
    ]);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Error: ' . $e->getMessage()
    ]);
}
?>
