<?php
header('Content-Type: application/json');
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");

require_once '../config/Database.php';

$action = $_GET['action'] ?? 'getUpcomingEvents';
$limit = isset($_GET['limit']) ? intval($_GET['limit']) : 20;

$db = new Database();
$pdo = $db->connect();

try {
    if ($action === 'getUpcomingEvents') {
        // Get upcoming events
        $query = "
            SELECT 
                e.id as event_id,
                e.event_name,
                e.event_type,
                e.event_date,
                e.start_time,
                e.end_time,
                e.location,
                e.event_description
            FROM events e
            WHERE e.event_date >= CURDATE()
            ORDER BY e.event_date ASC
            LIMIT :limit
        ";
        
        $stmt = $pdo->prepare($query);
        $stmt->bindValue(':limit', $limit, PDO::PARAM_INT);
        $stmt->execute();
        $events = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        echo json_encode([
            'success' => true,
            'message' => 'Events retrieved successfully',
            'data' => $events
        ]);
        
    } elseif ($action === 'getEvents') {
        // Get events by month and year
        $month = isset($_GET['month']) ? intval($_GET['month']) : date('m');
        $year = isset($_GET['year']) ? intval($_GET['year']) : date('Y');
        
        $query = "
            SELECT 
                e.id as event_id,
                e.event_name,
                e.event_type,
                e.event_date,
                e.start_time,
                e.end_time,
                e.location,
                e.event_description
            FROM events e
            WHERE MONTH(e.event_date) = :month 
            AND YEAR(e.event_date) = :year
            ORDER BY e.event_date ASC
        ";
        
        $stmt = $pdo->prepare($query);
        $stmt->bindValue(':month', $month, PDO::PARAM_INT);
        $stmt->bindValue(':year', $year, PDO::PARAM_INT);
        $stmt->execute();
        $events = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        echo json_encode([
            'success' => true,
            'message' => 'Events retrieved successfully',
            'data' => $events
        ]);
    } else {
        http_response_code(400);
        echo json_encode([
            'success' => false,
            'message' => 'Invalid action: ' . $action
        ]);
    }
} catch (PDOException $e) {
    http_response_code(500);
    error_log('API Events Error: ' . $e->getMessage());
    echo json_encode([
        'success' => false,
        'message' => 'Database error: ' . $e->getMessage()
    ]);
} catch (Exception $e) {
    http_response_code(500);
    error_log('API Events Exception: ' . $e->getMessage());
    echo json_encode([
        'success' => false,
        'message' => 'Error: ' . $e->getMessage()
    ]);
}
