<?php
header('Content-Type: application/json');
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");

require_once '../config/Database.php';

$action = $_GET['action'] ?? 'getDisciplineRecords';
$student_id = $_GET['student_id'] ?? 1;

$db = new Database();
$pdo = $db->connect();

try {
    if ($action === 'getDisciplineRecords') {
        // Get discipline records for student
        $query = "
            SELECT 
                dr.id as discipline_record_id,
                dr.student_id,
                dr.incident_type,
                dr.description as incident_description,
                dr.incident_date,
                dr.severity as severity_level,
                dr.action_taken,
                u.full_name as staff_name
            FROM discipline_records dr
            LEFT JOIN users u ON dr.reported_by = u.id
            WHERE dr.student_id = :student_id
            ORDER BY dr.incident_date DESC
        ";
        
        $stmt = $pdo->prepare($query);
        $stmt->bindValue(':student_id', $student_id, PDO::PARAM_INT);
        $stmt->execute();
        $records = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        echo json_encode([
            'success' => true,
            'message' => 'Discipline records retrieved successfully',
            'data' => $records
        ]);
    }
} catch (PDOException $e) {
    http_response_code(500);
    error_log('API Discipline Error: ' . $e->getMessage());
    echo json_encode([
        'success' => false,
        'message' => 'Database error: ' . $e->getMessage()
    ]);
} catch (Exception $e) {
    http_response_code(500);
    error_log('API Discipline Exception: ' . $e->getMessage());
    echo json_encode([
        'success' => false,
        'message' => 'Error: ' . $e->getMessage()
    ]);
}
