<?php
header('Content-Type: application/json');
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");

require_once '../config/Database.php';

$action = $_GET['action'] ?? 'getStudentActivities';
$student_id = $_GET['student_id'] ?? 1;

$db = new Database();
$pdo = $db->connect();

try {
    if ($action === 'getStudentActivities') {
        // Get activities student is participating in
        $query = "
            SELECT 
                eaa.id as activity_id,
                eaa.activity_name,
                eaa.description as activity_description,
                eaa.activity_type as category,
                eaa.meeting_day,
                eaa.meeting_time,
                eaa.location as venue,
                ap.achievements,
                u.full_name as staff_name
            FROM activity_participation ap
            JOIN extracurricular_activities eaa ON ap.activity_id = eaa.id
            LEFT JOIN users u ON eaa.coordinator_id = u.id
            WHERE ap.student_id = :student_id
            ORDER BY eaa.activity_name
        ";
        
        $stmt = $pdo->prepare($query);
        $stmt->bindValue(':student_id', $student_id, PDO::PARAM_INT);
        $stmt->execute();
        $activities = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        echo json_encode([
            'success' => true,
            'message' => 'Activities retrieved successfully',
            'data' => $activities
        ]);
        
    } elseif ($action === 'getActivities') {
        // Get all active activities
        $query = "
            SELECT 
                eaa.id as activity_id,
                eaa.activity_name,
                eaa.description as activity_description,
                eaa.activity_type as category,
                eaa.meeting_day,
                eaa.meeting_time,
                eaa.location as venue,
                eaa.is_active as status,
                u.full_name as staff_name
            FROM extracurricular_activities eaa
            LEFT JOIN users u ON eaa.coordinator_id = u.id
            WHERE eaa.is_active = 1
            ORDER BY eaa.activity_name
        ";
        
        $stmt = $pdo->prepare($query);
        $stmt->execute();
        $activities = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        echo json_encode([
            'success' => true,
            'message' => 'Activities retrieved successfully',
            'data' => $activities
        ]);
    }
} catch (PDOException $e) {
    http_response_code(500);
    error_log('API Activities Error: ' . $e->getMessage());
    echo json_encode([
        'success' => false,
        'message' => 'Database error: ' . $e->getMessage()
    ]);
} catch (Exception $e) {
    http_response_code(500);
    error_log('API Activities Exception: ' . $e->getMessage());
    echo json_encode([
        'success' => false,
        'message' => 'Error: ' . $e->getMessage()
    ]);
}
